/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.viewport.Viewport;

public class Energy
extends Group {
    private Image energyBar;
    private float maxEnergyWidth;
    private int energy = 100;

    public Energy(Viewport viewport) {
        Group energyGroup = new Group();
        energyGroup.setDebug(true);
        this.energyBar = new Image(new Texture(Gdx.files.internal("Interface/Energy Bar/green_bar.png")));
        Image energyBarOutline = new Image(new Texture(Gdx.files.internal("Interface/Energy Bar/bar_outline.png")));
        energyBarOutline.setPosition(viewport.getWorldWidth() - energyBarOutline.getWidth() - 15.0f, 15.0f);
        this.energyBar.setPosition(energyBarOutline.getX() + 16.0f, energyBarOutline.getY() + 16.0f);
        energyGroup.addActor(this.energyBar);
        energyGroup.addActor(energyBarOutline);
        Texture energyTexture = new Texture(Gdx.files.internal("Interface/Energy Bar/green_bar.png"));
        Texture outlineTexture = new Texture(Gdx.files.internal("Interface/Energy Bar/bar_outline.png"));
        this.energyBar = new Image(energyTexture);
        energyBarOutline = new Image(outlineTexture);
        energyBarOutline.setPosition(viewport.getWorldWidth() - 550.0f - energyBarOutline.getWidth() - 15.0f, 15.0f);
        this.energyBar.setPosition(energyBarOutline.getX() + 16.0f, energyBarOutline.getY() + 16.0f);
        this.maxEnergyWidth = this.energyBar.getWidth();
        this.addActor(this.energyBar);
        this.addActor(energyBarOutline);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        if (this.energy > 100) {
            this.energy = 100;
        }
        this.energyBar.setScaleY((float)this.energy / 100.0f);
    }

    public void decreaseEnergy(int energy) {
        this.energy -= energy;
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.energyBar.setScaleY((float)this.energy / 100.0f);
    }

    public int getEnergy() {
        return this.energy;
    }
}

